#include <bits/stdc++.h>
#define ll long long
#define INF 1000000000000000000LL
using namespace std;
int N, K;
long double eps0;
ll eps;
struct Point
{
  ll x, y;
}C[20001];
struct Edge
{
  int u, v;
}E[20001];
struct Node
{
  int p, r;
}DSU[20001];
struct Block
{
  int p, l;
  bool mst, t;
  ll lx, rx, ly, ry;
}B[41][41];
bitset <20001> P;
vector <pair <int, int>> L[20001];
inline ll getnum() {long double x; cin >> x; return x * 1e10;}
inline int Find(int u)
{
  while(u != DSU[u].p) u = DSU[u].p;
  return u;
}
inline bool Union(int u, int v)
{
  u = Find(u);
  v = Find(v);
  if(u == v) return false;
  if(DSU[u].r < DSU[v].r) swap(u, v);
  DSU[u].r += DSU[u].r == DSU[v].r;
  DSU[v].p = u;
  return true;
}
inline bool comp(int i, int j) {return (C[i].x + C[i].y) < (C[j].x + C[j].y);}
inline vector <array <ll, 3>> GetEdges(vector <int> &I)
{
  vector <array <ll, 3>> V;
  for(int k = 0; k < 4; k++)
  {
    sort(I.begin(), I.end(), comp);
    map <ll, int, greater <ll>> MAP;
    for(int i : I)
    {
      for(auto it = MAP.lower_bound(C[i].x); it != MAP.end(); MAP.erase(it++))
      {
        if((C[i].x - C[i].y) > (C[it->second].x - C[it->second].y)) break;
        V.push_back({C[i].x - C[it->second].x + C[i].y - C[it->second].y, i, it->second});
      }
      MAP[C[i].x] = i;
    }
    for(int i = 1; i <= N; i++)
    {
      if(k & 1) C[i].x = -C[i].x;
      else swap(C[i].x, C[i].y);
    }
  }
  for(int i = 1; i <= N; i++) C[i] = {-C[i].x, -C[i].y};
  if(V.size()) sort(V.begin(), V.end());
  return V;
}
inline int Kruskal(vector <array <ll, 3>> V)
{
  if(!V.size()) return 0;
  int M = 0;
  for(int i = 1; i <= N; i++) DSU[i] = {i, 0};
  for(auto a : V) if(Union(a[1], a[2])) E[++M] = {a[1], a[2]};
  return M;
}
inline bool HasPoint(Point p, int i, int j) {return (B[i][j].lx <= p.x) && (p.x <= B[i][j].rx) && (B[i][j].ly <= p.y) && (p.y <= B[i][j].ry);}
inline int Orientation(Point p, Point q, Point r)
{
  __int128 x1 = p.x, y1 = p.y, x2 = q.x, y2 = q.y, x = r.x, y = r.y;
  __int128 ret = (x - x1) * (y2 - y1) - (y - y1) * (x2 - x1);
  if(ret > 0) return +1;
  if(ret < 0) return -1;
  return 0;
}
inline bool LineIntersect(Point p, Point q, Point r, Point s)
{
  int pqr = Orientation(p, q, r), pqs = Orientation(p, q, s), rsp = Orientation(r, s, p), rsq = Orientation(r, s, q);
  if((pqr && (pqr == pqs)) || (rsp && (rsp == rsq))) return false;
  return true;
}
inline bool HasLine(Point p, Point q, int i, int j)
{
  if(HasPoint(p, i, j) || HasPoint(q, i, j)) return true;
  if(LineIntersect(p, q, {B[i][j].lx, B[i][j].ly}, {B[i][j].lx, B[i][j].ry})) return true;
  if(LineIntersect(p, q, {B[i][j].rx, B[i][j].ly}, {B[i][j].rx, B[i][j].ry})) return true;
  if(LineIntersect(p, q, {B[i][j].lx, B[i][j].ly}, {B[i][j].rx, B[i][j].ly})) return true;
  if(LineIntersect(p, q, {B[i][j].lx, B[i][j].ry}, {B[i][j].rx, B[i][j].ry})) return true;
  return false;
}
int main()
{
  ios_base::sync_with_stdio(0), cin.tie(0), cout.tie(0);
  cin >> N >> eps0;
  eps = eps0 * 1e10;
  K = round(18.0 / (eps0 * eps0));
  for(int i = 1; i <= N; i++) {C[i].x = getnum(); C[i].y = getnum();}
  vector <int> I;
  for(int i = 1; i <= N; i++) I.push_back(i);
  Kruskal(GetEdges(I));
  I = vector <int>();
  if(K >= N)
  {
    cout << N << '\n';
    for(int i = 1; i <= N; i++) cout << i << " \n"[i == N];
    for(int i = 1; i < N; i++) cout << E[i].u << ' ' << E[i].v << '\n';
    return 0;
  }
  int n = 10000000000LL / (eps >> 1);
  for(int i = 0; i < n; i++)
  {
    for(int j = 0; j < n; j++)
    {
      B[i][j].lx = i * (eps >> 1);
      B[i][j].rx = (i + 1) * (eps >> 1);
      B[i][j].ly = j * (eps >> 1);
      B[i][j].ry = (j + 1) * (eps >> 1);
    }
  }
  for(int k = 1; k <= N; k++)
  {
    bool remi = C[k].x % (eps >> 1), remj = C[k].y % (eps >> 1);
    int i = C[k].x / (eps >> 1) + remi, j = C[k].y / (eps >> 1) + remj;
    if(!remi)
    {
      if(!remj) {B[i - bool(i)][j - bool(j)].p = k; B[i - bool(i)][j - bool(j)].mst = true;}
      B[i - bool(i)][j].p = k;
      B[i - bool(i)][j].mst = true;
    }
    if(!remj) {B[i][j - bool(j)].p = k; B[i][j - bool(j)].mst = true;}
    B[i][j].p = k;
    B[i][j].mst = true;
  }
  for(int i = 1; i < N; i++) if((abs(C[E[i].u].x - C[E[i].v].x) + abs(C[E[i].u].y - C[E[i].v].y)) > (eps + (eps >> 1))) I.push_back(i);
  for(int i = 0; i < n; i++)
  {
    for(int j = 0; j < n; j++)
    {
      if(B[i][j].mst) continue;
      for(int k : I)
      {
        if(!HasLine(C[E[k].u], C[E[k].v], i, j)) continue;
        B[i][j].l = k;
        B[i][j].mst = true;
        L[k].push_back({i, j});
        break;
      }
    }
  }
  I = vector <int>();
  for(int i = 0; i < n; i++)
  {
    for(int j = 0; j < n; j++)
    {
      if(!B[i][j].mst || B[i][j].t || B[i][j].p) continue;
      P[E[B[i][j].l].u] = P[E[B[i][j].l].v] = 1;
      for(pair <int, int> p : L[B[i][j].l]) B[p.first][p.second].t = true;
    }
  }
  for(int i = 0; i < n; i++)
  {
    for(int j = 0; j < n; j++)
    {
      if(!B[i][j].mst || B[i][j].t) continue;
      P[B[i][j].p] = 1;
    }
  }
  for(int i = 1; i <= N; i++) if(P[i]) I.push_back(i);
  vector <array <ll, 3>> V = GetEdges(I);
  reverse(V.begin(), V.end());
  for(int i = 1; i < N; i++)
  {
    if(!P[E[i].u] || !P[E[i].v]) continue;
    V.push_back({0, E[i].u, E[i].v});
  }
  reverse(V.begin(), V.end());
  int M = Kruskal(V);
  cout << I.size() << '\n';
  for(int x : I) cout << x << ' ';
  cout << '\n';
  for(int i = 1; i <= M; i++) cout << E[i].u << ' ' << E[i].v << '\n';

  return 0;
}